/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.query;

import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.query.VWFieldListRenderer;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.table.AbstractTableModel;

class VWExposedFieldTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    protected static final int COL_NAME = 0;
    private VWSessionInfo m_sessionInfo = null;
    private boolean m_bSingleSelection = false;
    private Vector m_availableItems = null;
    private Vector m_selectedItems = null;

    public VWExposedFieldTableModel(VWSessionInfo sessionInfo, boolean bSingleSelection) {
        this.m_sessionInfo = sessionInfo;
        this.m_bSingleSelection = bSingleSelection;
        this.m_availableItems = new Vector();
        this.m_selectedItems = new Vector();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return JCheckBox.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_availableFieldsNoColon;
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.m_availableItems.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWExposedFieldDefinition exposedFieldDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (exposedFieldDef == null) break;
                    String fieldName = VWFieldListRenderer.getFieldName(exposedFieldDef);
                    JCheckBox tmpCheckBox = new JCheckBox(fieldName);
                    tmpCheckBox.setSelected(this.isSelectedExposedField(exposedFieldDef));
                    return tmpCheckBox;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reinitialize(VWQueueDefinition queueDef, VWExposedFieldDefinition[] selectedFields, boolean bIncludeSystemFields) {
        try {
            try {
                Object[] availableFields;
                this.m_availableItems = new Vector();
                this.m_selectedItems = new Vector();
                if (queueDef != null && (availableFields = queueDef.getFields()) != null && availableFields.length > 0) {
                    VWQubbleSort.sort(availableFields);
                    for (int nIndex = 0; nIndex < availableFields.length; ++nIndex) {
                        if (((VWExposedFieldDefinition)availableFields[nIndex]).isSystemField() && !bIncludeSystemFields || this.isPreviouslySelectedField((VWExposedFieldDefinition)availableFields[nIndex], selectedFields)) continue;
                        this.m_availableItems.addElement(availableFields[nIndex]);
                    }
                }
                Object var7_7 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
                Object var7_8 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    protected VWExposedFieldDefinition[] getSelectedFields() {
        if (this.m_selectedItems != null && this.m_selectedItems.size() > 0) {
            Object[] selectedFields = new VWExposedFieldDefinition[this.m_selectedItems.size()];
            this.m_selectedItems.copyInto(selectedFields);
            return selectedFields;
        }
        return null;
    }

    protected void setSelectedFields(VWExposedFieldDefinition[] selectedFields) {
        this.m_selectedItems = new Vector();
        if (selectedFields != null) {
            for (int nIndex = 0; nIndex < selectedFields.length; ++nIndex) {
                this.m_selectedItems.addElement(selectedFields[nIndex]);
            }
        }
        this.fireTableDataChanged();
    }

    protected void releaseResources() {
        if (this.m_availableItems != null) {
            this.m_availableItems.removeAllElements();
            this.m_availableItems = null;
        }
        if (this.m_selectedItems != null) {
            this.m_selectedItems.removeAllElements();
            this.m_selectedItems = null;
        }
        this.m_sessionInfo = null;
    }

    private VWExposedFieldDefinition getRowItemAt(int nRowIndex) {
        if (this.m_availableItems == null || nRowIndex < 0 || nRowIndex > this.m_availableItems.size()) {
            return null;
        }
        if (nRowIndex < this.m_availableItems.size()) {
            return (VWExposedFieldDefinition)this.m_availableItems.elementAt(nRowIndex);
        }
        return null;
    }

    private boolean isSelectedExposedField(VWExposedFieldDefinition exposedFieldDef) {
        if (this.m_selectedItems == null || this.m_selectedItems.size() == 0) {
            return false;
        }
        return this.m_selectedItems.indexOf(exposedFieldDef) != -1;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof JCheckBox)) {
                return;
            }
            VWExposedFieldDefinition exposedFieldDef = this.getRowItemAt(nRowIndex);
            if (exposedFieldDef != null) {
                if (((JCheckBox)aValue).isSelected()) {
                    if (this.m_bSingleSelection) {
                        for (int nIndex = 0; nIndex < this.getRowCount(); ++nIndex) {
                            VWExposedFieldDefinition tempRowItem;
                            if (nIndex == nRowIndex || !this.isSelectedExposedField(tempRowItem = this.getRowItemAt(nIndex))) continue;
                            this.m_selectedItems.removeElement(tempRowItem);
                            this.fireTableCellUpdated(nIndex, 0);
                        }
                    }
                    this.m_selectedItems.addElement(exposedFieldDef);
                } else {
                    this.m_selectedItems.removeElement(exposedFieldDef);
                }
                this.fireTableCellUpdated(nRowIndex, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private boolean isPreviouslySelectedField(VWExposedFieldDefinition fieldDef, VWExposedFieldDefinition[] previouslySelectedFields) {
        if (previouslySelectedFields == null || previouslySelectedFields.length == 0) {
            return false;
        }
        for (int nIndex = 0; nIndex < previouslySelectedFields.length; ++nIndex) {
            if (VWStringUtils.compare(fieldDef.getName(), previouslySelectedFields[nIndex].getName()) != 0) continue;
            return true;
        }
        return false;
    }
}

